class Babu:
    ures = 0
    kor = 1
    iksz = 2


class Jatek:
    def __init__(self, kor_nev, iksz_nev):
        """Új játékot kezd."""
        self.palya = []
        for _ in range(3):
            self.palya.append([Babu.ures] * 3)
        self.kovetkezo = Babu.kor
        self.kor_nev = kor_nev
        self.iksz_nev = iksz_nev


class Pozicio:
    def __init__(self, x, y):
        self.x = x
        self.y = y


def ki_a_kovetkezo(j):
    """Megadja, ki a következő játékos, ha most a megadott játékos lépett."""
    kovetkezo = {
        Babu.kor: Babu.iksz,
        Babu.iksz: Babu.kor,
    }
    return kovetkezo[j]


def kovetkezo_neve(j):
    """Megadja annak a játékosnak a nevét, aki a következő lépést teszi majd."""
    if j.kovetkezo == Babu.kor:
        return j.kor_nev
    if j.kovetkezo == Babu.iksz:
        return j.iksz_nev
    assert False   # ilyen nem történhet


def harmas(j, p, i, b):
    """Megmondja, hogy egy adott p pozícióból adott i irányba indulva
       az adott b babu van-e mindhárom helyen."""
    for n in range(3):
        if j.palya[p.y + n * i.y][p.x + n * i.x] != b:
            return False
    return True


def nyert_e(j, keresett):
    """Megmondja, van-e hármasa (nyert-e) az adott játékos."""
    # hol lehet, milyen irányokban? 3 vízszintes, 3 függőleges, 2 átlós.
    for y in range(3):
        if harmas(j, Pozicio(0, y), Pozicio(+1, 0), keresett):
            return True
    for x in range(3):
        if harmas(j, Pozicio(x, 0), Pozicio(0, +1), keresett):
            return True
    if harmas(j, Pozicio(0, 0), Pozicio(+1, +1), keresett):
        return True
    if harmas(j, Pozicio(0, 2), Pozicio(+1, -1), keresett):
        return True
    return False


def jatek_lep(j, p):
    """Lép a megadott játékos a megadott pozícióra.
    True értéket ad, ha megnyerte a játékos a játékot a lépésével."""
    j.palya[p.y][p.x] = j.kovetkezo
    nyert = nyert_e(j, j.kovetkezo)
    j.kovetkezo = ki_a_kovetkezo(j.kovetkezo)
    return nyert


def ment(j, fajlnev):
    """Elmenti a játékot egy fájlba."""
    with open(fajlnev, "wt") as f:
        f.write("Tictactoe v1\n")
        f.write(j.kor_nev + "\n")
        f.write(j.iksz_nev + "\n")
        f.write(str(j.kovetkezo) + "\n")
        for y in range(3):
            for x in range(3):
                f.write(str(j.palya[y][x]) + " ")
            f.write("\n")


def betolt(j, fajlnev):
    """Visszatölti a játékot a fájlból. Felülírja a paramterként adott játékot."""
    with open(fajlnev, "rt") as f:
        verzio = f.readline()   # itt ellenőrizhetnénk
        j.kor_nev = f.readline().rstrip("\n")
        j.iksz_nev = f.readline().rstrip("\n")
        j.kovetkezo = int(f.readline())
        for y in range(3):
            sor = f.readline().split(" ")
            for x in range(3):
                j.palya[y][x] = int(sor[x])
